Continuation lines should not be indented at the same level as the next logical line. Instead, they should be indented to one more level so as to distinguish them from the next line.

### Anti-pattern

In this example the second line is indented at the same level as the line below it. This makes it difficult to tell what is in the `if` block and what is a part of the boolean expression.

```python
if user is not None and user.is_admin or \
    user.name == 'Grant':
    blah = 'yeahnah'
```

### Best practice

```python
if user is not None and user.is_admin or \
        user.name == 'Grant':
    blah = 'yeahnah'
```
