Makes sure that all pods have a security context with read only filesystem set.

# Details
Usually, a container only needs `write` access to a mounted volume, which stores data and the current state not only for this container instance but also all its replicas.
Configuring the containers to have `read-only` root file system rights decreases the attack surface and can prevent malicious processes to store or manipulate data inside a container.
Otherwise, an attacker who compromised the container could write an executable file and run it inside the container.

# Further Reading:
- Jim Bugwadia. 10 Kubernetes Best Practices You Can Easily Apply to Your Clusters. Nov. 14, 2019. url: https://thenewstack.io/10-kubernetes-best-practices-you-can-easily-apply-to-your-clusters/
- Gabriel Avner. Kubernetes Pod Security Policy Best Practices. Apr. 2, 2019. url: https://resources.whitesourcesoftware.com/blog-whitesource/kubernetes-pod-security-policy
- Liz Rice and Michael Hausenblas. Kubernetes Security. First Edition. Sebastopol: O’Reilly Media, Inc., 2018. isbn: 9781492039068.