### SCS0001 - Command Injection 

The dynamic value passed to the command execution should be validated.

#### Risk

If a malicious user controls either the FileName or Arguments, he might be able to execute unwanted commands or add unwanted argument. This behavior would not be possible if input parameter are validate against a white-list of characters.

#### Vulnerable Code

```cs
var p = new Process();
p.StartInfo.FileName = "exportLegacy.exe";
p.StartInfo.Arguments = " -user " + input + " -role user";
p.Start();

```

#### Solution

```cs
Regex rgx = new Regex(@"^[a-zA-Z0-9]+$");
if(rgx.IsMatch(input))
{
    var p = new Process();
    p.StartInfo.FileName = "exportLegacy.exe";
    p.StartInfo.Arguments = " -user " + input + " -role user";
    p.Start();
}

```

#### References

[CWE-78: Improper Neutralization of Special Elements used in an OS Command (‘OS Command Injection’)](https://cwe.mitre.org/data/definitions/78.html)  
[OWASP: Command Injection](https://www.owasp.org/index.php/Command%5FInjection)  
[OWASP: Top 10 2013-A1-Injection](https://www.owasp.org/index.php/Top%5F10%5F2013-A1-Injection)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)