### SCS0002 - SQL Injection 

SQL injection flaws are introduced when software developers create dynamic database queries that include user supplied input.

#### Risk

Malicious user might get direct read and/or write access to the database. If the database is poorly configured the attacker might even get Remote Code Execution (RCE) on the machine running the database.

#### Vulnerable Code

```cs
var cmd = "SELECT * FROM Users WHERE username = '" + input + "' and role='user'";
ctx.Database.ExecuteSqlCommand(
    cmd);

```

#### Solution

Use parametrized queries to mitigate SQL injection.

```cs
var cmd = "SELECT * FROM Users WHERE username = @username and role='user'";
ctx.Database.ExecuteSqlCommand(
    cmd,
    new SqlParameter("@username", input));

```

#### References

[CWE-89: Improper Neutralization of Special Elements used in an SQL Command (‘SQL Injection’)](https://cwe.mitre.org/data/definitions/89.html)  
[WASC-19: SQL Injection](http://projects.webappsec.org/w/page/13246963/SQL%20Injection)  
[OWASP: SQL Injection Prevention Cheat Sheet](https://www.owasp.org/index.php/SQL%5FInjection%5FPrevention%5FCheat%5FSheet)  
[OWASP: Query Parameterization Cheat Sheet](https://www.owasp.org/index.php/Query%5FParameterization%5FCheat%5FSheet)  
[CAPEC-66: SQL Injection](http://capec.mitre.org/data/definitions/66.html)  
[Bobby Tables: A guide to preventing SQL injection](http://bobby-tables.com/csharp)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)