<h2>Why is this an issue?</h2>
<p>Putting multiple statements on a single line lowers the code readability and makes debugging the code more complex.</p>
<pre>
if (someCondition) DoSomething(); // Noncompliant
</pre>
<p>Write one statement per line to improve readability.</p>
<pre>
if (someCondition)
{
  DoSomething();
}
</pre>
<h3>Exceptions</h3>
<p>The rule ignores:</p>
<ul>
  <li> block statements </li>
  <li> anonymous functions containing a single statement </li>
</ul>
<pre>
Func&lt;object, bool&gt; item1 = o =&gt; { return true; }; // Compliant by exception
Func&lt;object, bool&gt; item1 = o =&gt; { var r = false; return r; }; // Noncompliant
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/fundamentals/code-analysis/style-rules/csharp-formatting-options">C# formatting options</a>
  </li>
</ul>

