<h2>Why is this an issue?</h2>
<p><code>StringBuilder</code> is more efficient than string concatenation, especially when the operator is repeated over and over as in loops.</p>
<h3>Noncompliant code example</h3>
<pre>
string str = "";
for (int i = 0; i &lt; arrayOfStrings.Length ; ++i)
{
  str = str + arrayOfStrings[i];
}
</pre>
<h3>Compliant solution</h3>
<pre>
StringBuilder bld = new StringBuilder();
for (int i = 0; i &lt; arrayOfStrings.Length; ++i)
{
  bld.Append(arrayOfStrings[i]);
}
string str = bld.ToString();
</pre>

