<h2>Why is this an issue?</h2>
<p>When the same code is duplicated in two or more separate branches of a conditional, it can make the code harder to understand, maintain, and can
potentially introduce bugs if one instance of the code is changed but others are not.</p>
<p>Having two <code>cases</code> in a <code>switch</code> statement or two branches in an <code>if</code> chain with the same implementation is at
best duplicate code, and at worst a coding error.</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
if (a &gt;= 0 &amp;&amp; a &lt; 10)
{
  DoFirst();
  DoTheThing();
}
else if (a &gt;= 10 &amp;&amp; a &lt; 20)
{
  DoTheOtherThing();
}
else if (a &gt;= 20 &amp;&amp; a &lt; 50) // Noncompliant; duplicates first condition
{
  DoFirst();
  DoTheThing();
}
</pre>
<pre data-diff-id="2" data-diff-type="noncompliant">
switch (i)
{
  case 1:
    DoFirst();
    DoSomething();
    break;
  case 2:
    DoSomethingDifferent();
    break;
  case 3:  // Noncompliant; duplicates case 1's implementation
    DoFirst();
    DoSomething();
    break;
  default:
    DoTheRest();
}
</pre>
<p>If the same logic is truly needed for both instances, then:</p>
<ul>
  <li> in an <code>if</code> chain they should be combined </li>
</ul>
<pre data-diff-id="1" data-diff-type="compliant">
if ((a &gt;= 0 &amp;&amp; a &lt; 10) || (a &gt;= 20 &amp;&amp; a &lt; 50))
{
  DoFirst();
  DoTheThing();
}
else if (a &gt;= 10 &amp;&amp; a &lt; 20)
{
  DoTheOtherThing();
}
</pre>
<ul>
  <li> for a <code>switch</code>, one should fall through to the other </li>
</ul>
<pre data-diff-id="2" data-diff-type="compliant">
switch (i)
{
  case 1:
  case 3:
    DoFirst();
    DoSomething();
    break;
  case 2:
    DoSomethingDifferent();
    break;
  default:
    DoTheRest();
}
</pre>
<h3>Exceptions</h3>
<p>The rule does not raise an issue for blocks in an <code>if</code> chain that contain a single line of code. The same applies to blocks in a
<code>switch</code> statement that contain a single line of code with or without a following <code>break</code>.</p>
<pre>
if (a &gt;= 0 &amp;&amp; a &lt; 10)
{
  DoTheThing();
}
else if (a &gt;= 10 &amp;&amp; a &lt; 20)
{
  DoTheOtherThing();
}
else if (a &gt;= 20 &amp;&amp; a &lt; 50)    //no issue, usually this is done on purpose to increase the readability
{
  DoTheThing();
}
</pre>
<p>However, this exception does not apply to <code>if</code> chains without an <code>else</code> statement or to a <code>switch</code> statement
without a <code>default</code> clause.</p>
<pre>
if (a == 1)
{
  DoSomething();  // Noncompliant, this might have been done on purpose but probably not
}
else if (a == 2)
{
  DoSomething();
}
</pre>
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> {rule:csharpsquid:S3923} - All branches in a conditional structure should not have exactly the same implementation </li>
</ul>

