<h2>Why is this an issue?</h2>
<p>There is no good excuse for an empty class. If it’s being used simply as a common extension point, it should be replaced with an
<code>interface</code>. If it was stubbed in as a placeholder for future development it should be fleshed-out. In any other case, it should be
eliminated.</p>
<h3>Noncompliant code example</h3>
<pre>
public class Empty // Noncompliant
{
}
</pre>
<h3>Compliant solution</h3>
<pre>
public interface IEmpty
{
}
</pre>
<h3>Exceptions</h3>
<ul>
  <li> Partial classes are ignored entirely, as source generators often use them. </li>
  <li> Classes with names ending in <code>Command</code>, <code>Message</code>, <code>Event</code>, or <code>Query</code> are ignored as messaging
  libraries often use them. </li>
  <li> Subclasses of <code>System.Exception</code> are ignored; even an empty Exception class can provide helpful information by its type name alone.
  </li>
  <li> Subclasses of <code>System.Attribute</code> and classes annotated with attributes are ignored. </li>
  <li> Subclasses of generic classes are ignored, as they can be used for type specialization even when empty. </li>
  <li> Subclasses of certain framework types — like the <code>PageModel</code> class used in ASP.NET Core Razor Pages — are ignored. </li>
  <li> Subclass of a class with non-public default constructors are ignored, as they widen the constructor accessibility. </li>
</ul>
<pre>
using Microsoft.AspNetCore.Mvc.RazorPages;

public class EmptyPageModel: PageModel // Compliant - an empty PageModel can be fully functional, the C# code can be in the cshtml file
{
}
</pre>

