<h2>Why is this an issue?</h2>
<p>Properties with only setters are confusing and counterintuitive. Instead, a property getter should be added if possible, or the property should be
replaced with a setter method.</p>
<h3>Noncompliant code example</h3>
<pre>
class Program
{
    public int Foo  //Non-Compliant
    {
        set
        {
            // ... some code ...
        }
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
class Program
{
    private int foo;

    public void SetFoo(int value)
    {
        // ... some code ...
        foo = value;
    }
}
</pre>
<p>or</p>
<pre>
class Program
{
  public int Foo { get; set; } // Compliant
}
</pre>

