<h2>Why is this an issue?</h2>
<p>A <code>catch</code> clause that only rethrows the caught exception has the same effect as omitting the <code>catch</code> altogether and letting
it bubble up automatically.</p>
<pre>
string s = "";
try
{
  s = File.ReadAllText(fileName);
}
catch (Exception e)  // Noncompliant
{
  throw;
}
</pre>
<p>Such clauses should either be removed or populated with the appropriate logic.</p>
<pre>
string s = File.ReadAllText(fileName);
</pre>
<p>or</p>
<pre>
string s = "";
try
{
  s = File.ReadAllText(fileName);
}
catch (Exception e)
{
  logger.LogError(e);
  throw;
}
</pre>
<h3>Exceptions</h3>
<p>This rule will not generate issues for <code>catch</code> blocks if they are followed by a <code>catch</code> block for a more general exception
type that does more than just rethrowing the exception.</p>
<pre>
var s = ""
try
{
    s = File.ReadAllText(fileName);
}
catch (IOException) // Compliant by exception: removing it would change the logic
{
    throw;
}
catch (Exception)  // Compliant: does more than just rethrow
{
    logger.LogError(e);
    throw;
}
</pre>

