<h2>Why is this an issue?</h2>
<p>The rules for method resolution are complex and perhaps not properly understood by all coders. The <code>params</code> keyword can make method
declarations overlap in non-obvious ways, so that slight changes in the argument types of an invocation can resolve to different methods.</p>
<p>This rule raises an issue when an invocation resolves to a method declaration with <code>params</code>, but could also resolve to another
non-<code>params</code> method too.</p>
<h3>Noncompliant code example</h3>
<pre>
public class MyClass
{
    private void Format(string a, params object[] b) { }

    private void Format(object a, object b, object c) { }
}

// ...
MyClass myClass = new MyClass();

myClass.Format("", null, null); // Noncompliant, resolves to the first Format with params, but was that intended?
</pre>

