<h2>Why is this an issue?</h2>
<p>Overriding methods automatically inherit the <code>params</code> behavior. To ease readability, this modifier should be explicitly used in the
overriding method as well.</p>
<h3>Noncompliant code example</h3>
<pre>
class Base
{
  public virtual void Method(params int[] numbers)
  {
    ...
  }
}
class Derived : Base
{
  public override void Method(int[] numbers) // Noncompliant, the params is missing.
  {
    ...
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
class Base
{
  public virtual void Method(params int[] numbers)
  {
    ...
  }
}
class Derived : Base
{
  public override void Method(params int[] numbers)
  {
    ...
  }
}
</pre>

