<h2>Why is this an issue?</h2>
<p>If you’re using a <code>struct</code>, it is likely because you’re interested in performance. But by failing to implement
<code>IEquatable&lt;T&gt;</code> you’re loosing performance when comparisons are made because without <code>IEquatable&lt;T&gt;</code>, boxing and
reflection are used to make comparisons.</p>
<h3>Noncompliant code example</h3>
<pre>
struct MyStruct  // Noncompliant
{
    public int Value { get; set; }
}
</pre>
<h3>Compliant solution</h3>
<pre>
struct MyStruct : IEquatable&lt;MyStruct&gt;
{
    public int Value { get; set; }

    public bool Equals(MyStruct other)
    {
        // ...
    }
}
</pre>
<h2>Resources</h2>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.iequatable-1">IEquatable&lt;T&gt; Interface</a> </li>
</ul>

