<h2>Why is this an issue?</h2>
<p>The NET Framework 2.0 introduced the generic interface <code>System.Collections.Generic.IEnumerable&lt;T&gt;</code> and it should be preferred over
the older, non generic, interfaces.</p>
<p>This rule raises an issue when a public type implements <code>System.Collections.IEnumerable</code>.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;
using System.Collections;

public class MyData
{
  public MyData()
  {
  }
}

public class MyList : CollectionBase // Noncompliant
{
  public void Add(MyData data)
  {
    InnerList.Add(data);
  }

  // ...
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;
using System.Collections.ObjectModel;

public class MyData
{
  public MyData()
  {
  }
}

public class MyList : Collection&lt;MyData&gt;
{
  // Implementation...
}
</pre>

