<h2>Why is this an issue?</h2>
<p>Serialization event handlers that don’t have the correct signature will not be called, bypassing augmentations to automated serialization and
deserialization events.</p>
<p>A method is designated a serialization event handler by applying one of the following serialization event attributes:</p>
<ul>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/api/system.runtime.serialization.onserializingattribute"><code>OnSerializingAttribute</code></a>
  </li>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/api/system.runtime.serialization.onserializedattribute"><code>OnSerializedAttribute</code></a> </li>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/api/system.runtime.serialization.ondeserializingattribute"><code>OnDeserializingAttribute</code></a>
  </li>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/api/system.runtime.serialization.ondeserializedattribute"><code>OnDeserializedAttribute</code></a>
  </li>
</ul>
<p>Serialization event handlers take a single parameter of type <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.runtime.serialization.streamingcontext"><code>StreamingContext</code></a>, return
<code>void</code>, and have <code>private</code> visibility.</p>
<p>This rule raises an issue when any of these constraints are not respected.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
[Serializable]
public class Foo
{
    [OnSerializing]
    public void OnSerializing(StreamingContext context) {} // Noncompliant: should be private

    [OnSerialized]
    int OnSerialized(StreamingContext context) {} // Noncompliant: should return void

    [OnDeserializing]
    void OnDeserializing() {} // Noncompliant: should have a single parameter of type StreamingContext

    [OnSerializing]
    public void OnSerializing2&lt;T&gt;(StreamingContext context) {} // Noncompliant: should have no type parameters

    [OnDeserialized]
    void OnDeserialized(StreamingContext context, string str) {} // Noncompliant: should have a single parameter of type StreamingContext
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
[Serializable]
public class Foo
{
    [OnSerializing]
    private void OnSerializing(StreamingContext context) {}

    [OnSerialized]
    private void OnSerialized(StreamingContext context) {}

    [OnDeserializing]
    private void OnDeserializing(StreamingContext context) {}

    [OnDeserialized]
    private void OnDeserialized(StreamingContext context) {}
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/visualstudio/code-quality/ca2238">CA2238: Implement serialization methods
  correctly</a> </li>
</ul>

