<h2>Why is this an issue?</h2>
<p>Certain characters, once normalized to lowercase, cannot make a round trip. That is, they can not be converted from one locale to another and then
accurately restored to their original characters.</p>
<p>It is therefore strongly recommended to normalize characters and strings to uppercase instead.</p>
<h3>Noncompliant code example</h3>
<pre>
Thread.CurrentThread.CurrentCulture = new CultureInfo("tr-TR");
var areStringEqual = "INTEGER".ToLower() == "integer"; // Noncompliant, the result is false as the ToLower will resolve to "ınteger"
var areCharEqual = char.ToLower('I') == 'i'; // Noncompliant, the result is false as the ToLower will resolve to "ı"

var incorrectRoundtrip = "İ".ToLowerInvariant().ToUpper() == "I".ToLowerInvariant().ToUpper(); // Noncompliant, because of the lower we lose the information about the correct uppercase character
</pre>
<h3>Compliant solution</h3>
<pre>
Thread.CurrentThread.CurrentCulture = new CultureInfo("tr-TR");
var areStringEqual = "ınteger".ToUpperInvariant() == "ıNTEGER";
var areCharEqual = char.ToUpperInvariant('ı') == 'ı';
var correctRoundtrip = "İ".ToUpperInvariant().ToLower() != "I".ToUpperInvariant().ToLower();
</pre>
<h2>Resources</h2>
<ul>
  <li> <a href="http://www.i18nguy.com/unicode/turkish-i18n.html">Internationalization for Turkish</a> </li>
  <li> <a href="https://gingter.org/2018/07/10/how-to-correctly-normalize-strings-and-how-to-compare-them-in-net/">How to correctly normalize
  strings</a> </li>
  <li> <a href="https://docs.microsoft.com/en-us/dotnet/standard/base-types/best-practices-strings#recommendations-for-string-usage">Best Practices
  for Using Strings in .NET</a> </li>
</ul>

