<h2>Why is this an issue?</h2>
<p>A method using the <code>VarArgs</code> calling convention is not Common Language Specification (CLS) compliant and might not be accessible across
programming languages, while the <code>params</code> keyword works the same way and is CLS compliant.</p>
<p>This rule raises an issue when a <code>public</code> or <code>protected</code> type contains a <code>public</code> or <code>protected</code> method
that uses the <code>VarArgs</code> calling convention.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
    public class Foo
    {
        public void Bar(__arglist) // Noncompliant
        {
            ArgIterator argumentIterator = new ArgIterator(__arglist);
            for(int i = 0; i &lt; argumentIterator.GetRemainingCount(); i++)
            {
                Console.WriteLine(
                    __refvalue(argumentIterator.GetNextArg(), string));
            }
        }
    }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

[assembly: CLSCompliant(true)]
namespace MyLibrary
{
    public class Foo
    {
        public void Bar(params string[] wordList)
        {
            for(int i = 0; i &lt; wordList.Length; i++)
            {
                Console.WriteLine(wordList[i]);
            }
        }
    }
}
</pre>
<h3>Exceptions</h3>
<p>Interop methods using <code>VarArgs</code> calling convention do not raise an issue.</p>
<pre>
[DllImport("msvcrt40.dll")]
public static extern int printf(string format, __arglist); // Compliant
</pre>

