<h2>Why is this an issue?</h2>
<p>The <code>DebuggerDisplayAttribute</code> is used to determine how an object is displayed in the debugger window.</p>
<p>The <code>DebuggerDisplayAttribute</code> constructor takes a single mandatory argument: the string to be displayed in the value column for
instances of the type. Any text within curly braces is evaluated as the name of a field or property, or any complex expression containing method calls
and operators.</p>
<p>Naming a non-existent member between curly braces will result in a CS0103 error in the debug window when debugging objects. Although there is no
impact on the production code, providing a wrong value can lead to difficulties when debugging the application.</p>
<p>This rule raises an issue when text specified between curly braces refers to members that don’t exist in the current context.</p>
<h3>Noncompliant code example</h3>
<pre>
[DebuggerDisplay("Name: {Name}")] // Noncompliant - Name doesn't exist in this context
public class Person
{
    public string FullName { get; private set; }
}
</pre>
<h3>Compliant solution</h3>
<pre>
[DebuggerDisplay("Name: {FullName}")]
public class Person
{
    public string FullName { get; private set; }
}
</pre>

