<h2>Why is this an issue?</h2>
<p><a href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/regular-expressions">Regular expressions</a> have their own syntax that is
understood by regular expression engines. Those engines will throw an exception at runtime if they are given a regular expression that does not
conform to that syntax.</p>
<p>To avoid syntax errors, special characters should be <a
href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/character-escapes-in-regular-expressions">escaped with backslashes</a> when they
are intended to be matched literally and references to capturing groups should use the correctly spelled name or number of the group.</p>
<p>Negative <a
href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/regular-expression-language-quick-reference#lookarounds-at-a-glance">lookaround</a>
groups cannot be combined with <a
href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/backtracking-in-regular-expressions">RegexOptions.NonBacktracking</a>. Such
combination would throw an exception during runtime.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
void Regexes(string input)
{
    var regex = new Regex("[A");                                                    // Noncompliant
    var match = Regex.Match(input, "[A");                                           // Noncompliant
    var negativeLookahead = new Regex("a(?!b)", RegexOptions.NonBacktracking);      // Noncompliant
    var negativeLookbehind = new Regex("(?&lt;!a)b", RegexOptions.NonBacktracking);    // Noncompliant
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
void Regexes(string input)
{
    var regex = new Regex("[A-Z]");
    var match = Regex.Match(input, "[A-Z]");
    var negativeLookahead = new Regex("a(?!b)");
    var negativeLookbehind = new Regex("(?&lt;!a)b");
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/regular-expressions">.NET Regular expressions</a> </li>
  <li> <a
  href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/regular-expression-language-quick-reference#lookarounds-at-a-glance">Lookarounds
  at a glance</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/backtracking-in-regular-expressions">Backtracking in Regular
  Expressions</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/standard/base-types/character-escapes-in-regular-expressions">Character Escapes in Regular
  Expressions</a> </li>
</ul>

