<h2>Why is this an issue?</h2>
<p>With <code>string.StartsWith(char)</code> and <code>string.EndsWith(char)</code>, only the first character of the string is compared to the
provided character, whereas the <code>string</code> versions of those methods have to do checks about the current <code>StringComparison</code> and
<code>CultureInfo</code>. Thus, the <code>char</code> overloads are significantly faster for default comparison scenarios.</p>
<p>These overloads were introduced in <code>.NET Core 2.0</code>.</p>
<h3>What is the potential impact?</h3>
<p>We measured at least 3.5x improvement in execution time. For more details see the <code>Benchmarks</code> section from the <code>More info</code>
tab.</p>
<h2>How to fix it</h2>
<p>If you are targeting a runtime version equal or greater than <code>.NET Core 2.0</code>, the <code>string.StartsWith</code> and
<code>string.EndsWith</code> overloads are available, with the argument’s type being <code>char</code> instead of <code>string</code>. Thus, an
argument of <code>char</code> type can be provided.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
bool StartsWithSlash(string s) =&gt;
    s.StartsWith("/");
</pre>
<pre data-diff-id="2" data-diff-type="noncompliant">
bool EndsWithSlash(string s) =&gt;
    s.EndsWith("/");
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
bool StartsWithSlash(string s) =&gt;
    s.StartsWith('/');
</pre>
<pre data-diff-id="2" data-diff-type="compliant">
bool EndsWithSlash(string s) =&gt;
    s.EndsWith('/');
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.string.startswith">string.StartsWith</a> </li>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/api/system.string.endswith">string.EndsWith</a> </li>
</ul>
<h3>Benchmarks</h3>
<table>
  <colgroup>
    <col style="width: 33.3333%;">
    <col style="width: 33.3333%;">
    <col style="width: 33.3334%;">
  </colgroup>
  <thead>
    <tr>
      <th>Method</th>
      <th>Mean</th>
      <th>Standard Deviation</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td><p>StartsWith_String</p></td>
      <td><p>30.965 ms</p></td>
      <td><p>3.2732 ms</p></td>
    </tr>
    <tr>
      <td><p>StartsWith_Char</p></td>
      <td><p>7.568 ms</p></td>
      <td><p>0.3235 ms</p></td>
    </tr>
    <tr>
      <td><p>EndsWith_String</p></td>
      <td><p>30.421 ms</p></td>
      <td><p>5.1136 ms</p></td>
    </tr>
    <tr>
      <td><p>EndsWith_Char</p></td>
      <td><p>8.067 ms</p></td>
      <td><p>0.7092 ms</p></td>
    </tr>
  </tbody>
</table>
<h4>Glossary</h4>
<ul>
  <li> <a href="https://en.wikipedia.org/wiki/Arithmetic_mean">Mean</a> </li>
  <li> <a href="https://en.wikipedia.org/wiki/Standard_deviation">Standard Deviation</a> </li>
</ul>
<p>The results were generated by running the following snippet with <a href="https://github.com/dotnet/BenchmarkDotNet">BenchmarkDotNet</a>:</p>
<pre>
private List&lt;string&gt; data;

[Params(1_000_000)]
public int N { get; set; }

[GlobalSetup]
public void Setup() =&gt;
    data = Enumerable.Range(0, N).Select(_ =&gt; Guid.NewGuid().ToString()).ToList();

[Benchmark]
public void StartsWith_String()
{
    _ = data.Where(guid =&gt; guid.StartsWith("d")).ToList();
}

[Benchmark]
public void StartsWith_Char()
{
    _ = data.Where(guid =&gt; guid.StartsWith('d')).ToList();
}

[Benchmark]
public void EndsWith_String()
{
    _ = data.Where(guid =&gt; guid.EndsWith("d")).ToList();
}

[Benchmark]
public void EndsWith_Char()
{
    _ = data.Where(guid =&gt; guid.EndsWith('d')).ToList();
}
</pre>
<p>Hardware configuration:</p>
<pre>
BenchmarkDotNet=v0.13.5, OS=Windows 10 (10.0.19045.2846/22H2/2022Update)
11th Gen Intel Core i7-11850H 2.50GHz, 1 CPU, 16 logical and 8 physical cores
.NET SDK=7.0.203
  [Host]   : .NET 7.0.5 (7.0.523.17405), X64 RyuJIT AVX2
  .NET 7.0 : .NET 7.0.5 (7.0.523.17405), X64 RyuJIT AVX2
</pre>

