<p>In <a href="https://learn.microsoft.com/en-us/aspnet/core">ASP.NET Core</a>, controllers usually inherit either from <a
href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.controllerbase"><code>ControllerBase</code></a> or <a
href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.controller"><code>Controller</code></a>. If a controller does not use any
View-specific functionality, it is recommended to inherit from <code>ControllerBase</code>.</p>
<h2>Why is this an issue?</h2>
<p>The <code>ControllerBase</code> class contains all the necessary functionality to handle <a href="https://en.wikipedia.org/wiki/Web_API">API</a>
requests and responses. The <code>Controller</code> class inherits from <code>ControllerBase</code> and adds support for <a
href="https://learn.microsoft.com/en-us/aspnet/core/mvc/views/overview">Views</a>, <a
href="https://learn.microsoft.com/en-us/aspnet/core/mvc/views/partial">PartialViews</a> and <a
href="https://learn.microsoft.com/en-us/aspnet/core/mvc/views/view-components">ViewComponents</a>.</p>
<p>Inheriting from <code>Controller</code> when not using any View-specific functionality exposes unnecessary methods and can lead to confusion about
the intention of the class.</p>
<p>Furthermore, inheriting from <code>Controller</code> may come with a performance cost. Even though the controller might only deal with API
operations, the support for Views might introduce some overhead from the MVC framework during the <a
href="https://learn.microsoft.com/en-us/aspnet/core/fundamentals/middleware">request processing pipeline</a>.</p>
<p>An issue is raised when:</p>
<ul>
  <li> The class is marked with the <a
  href="https://learn.microsoft.com/en-us/aspnet/core/web-api#apicontroller-attribute"><code>[ApiController]</code></a> attribute. </li>
  <li> The class inherits <em>directly</em> from <code>Controller</code>. </li>
  <li> No View-specific functionality is used in the class. </li>
</ul>
<h3>Exceptions</h3>
<ul>
  <li> If a class is marked with the <a
  href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.noncontrollerattribute"><code>[NonController]</code></a> attribute.
  </li>
  <li> If a class does not have <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/keywords/public">public</a> accessibility.
  </li>
</ul>
<h2>How to fix it</h2>
<p>Change the base type of the controller from <code>Controller</code> to <code>ControllerBase</code>.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
[ApiController]
public class MyController : Controller // Noncompliant: Inherit from ControllerBase instead of Controller.
//                          ^^^^^^^^^^
{
    // ..
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
[ApiController]
public class MyController : ControllerBase
{
    // ..
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Web_API">Web API</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/aspnet/core">ASP.NET Core</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.controller">Controller Class</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.controllerbase">ControllerBase Class</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.apicontrollerattribute">ApiControllerAttribute
  Class</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/microsoft.aspnetcore.mvc.noncontrollerattribute">NonControllerAttribute
  Class</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/aspnet/core/mvc/views/overview">Views in ASP.NET Core MVC</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/aspnet/core/mvc/views/partial">Partial Views in ASP.NET Core MVC</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/aspnet/core/mvc/views/view-components">View Components in ASP.NET Core MVC</a>
  </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/aspnet/core/fundamentals/middleware">ASP.NET Core Middleware</a> </li>
</ul>

