﻿# SA0002

<table>
<tr>
  <td>TypeName</td>
  <td>SA0002InvalidSettingsFile</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA0002</td>
</tr>
<tr>
  <td>Category</td>
  <td>Special Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The **stylecop.json** settings file could not be loaded due to a deserialization error.

## Rule description

This rule reports cases where the StyleCop Analyzers settings file could not be loaded. When this occurs, the various
analyzers automatically fall back to using the default settings, which may not match the user's expectations.

## How to fix violations

To fix a violation of this rule, start by checking the following items:

* Ensure <em>stylecop.json</em> contains valid JSON syntax. The file may be opened in Visual Studio 2015 to check for
  common errors (they are reported by the IDE in the Errors window).
* Review the [configuration](Configuration.md) documentation and ensure the contents of <em>stylecop.json</em> contain
  valid settings.

## How to suppress violations

This warning can only be suppressed by disabling the warning in the **ruleset** file for the project.
