﻿## SA1000

<table>
<tr>
  <td>TypeName</td>
  <td>SA1000KeywordsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1000</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

The spacing around a C# keyword is incorrect.

## Rule description

A violation of this rule occurs when the spacing around a keyword is incorrect.

The following C# keywords should always be followed by a single space: `and`, `await`, `case`, `catch`, `fixed`, `for`,
`foreach`, `from`, `group`, `if`, `in`, `is`, `into`, `join`, `let`, `lock`, `not`, `orderby`, `or`, `out`, `ref`, `return`, `select`,
`switch`, `using`, `var`, `where`, `while`, `yield`.

The following keywords should not be followed by any space: `checked`, `default`, `nameof`, `sizeof`, `typeof`, `unchecked`.

The `new` and `stackalloc` keywords should always be followed by a space, except in the following cases:

* The `new` or `stackalloc` keyword is used to create a new implicitly-typed array. In this case there should be no
  space between the keyword and the opening array bracket.
* The `new` keyword is part of implicit object creation (target-typed new). In this case there should be no space between the keyword and the opening parenthesis.
* The `new` keyword is part of a generic type constraint. In this case there should be no space between the `new`
  keyword and the opening parenthesis.

The `throw` keyword should always be followed by a space, unless it is part of a re-throw statement, in which case there
should be no space between the `throw` keyword and the semicolon.

## How to fix violations

To fix a violation of this rule, add or remove a space after the keyword, according to the description above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1000:KeywordsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1000 // KeywordsMustBeSpacedCorrectly
#pragma warning restore SA1000 // KeywordsMustBeSpacedCorrectly
```
