﻿## SA1008

<table>
<tr>
  <td>TypeName</td>
  <td>SA1008OpeningParenthesisMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1008</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An opening parenthesis within a C# statement is not spaced correctly.

## Rule description

A violation of this rule occurs when the opening parenthesis within a statement is not spaced correctly. An opening parenthesis should not be preceded by any whitespace, unless it is the first character on the line, or it is preceded by certain C# keywords such as if, while, or for. In addition, an opening parenthesis is allowed to be preceded by whitespace when it follows an operator symbol within an expression.

An opening parenthesis should not be followed by whitespace, unless it is the last character on the line.

## How to fix violations

To fix a violation of this rule, ensure that the spacing around the opening parenthesis follows the rule described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1008:OpeningParenthesisMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1008 // OpeningParenthesisMustBeSpacedCorrectly
#pragma warning restore SA1008 // OpeningParenthesisMustBeSpacedCorrectly
```
