﻿## SA1018

<table>
<tr>
  <td>TypeName</td>
  <td>SA1018NullableTypeSymbolsMustNotBePrecededBySpace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1018</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A nullable type symbol within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around a nullable type symbol is not correct.

A nullable type symbol should never be preceded by whitespace, unless the symbol is the first character on the line.

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace before the nullable type symbol.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1018:NullableTypeSymbolsMustNotBePrecededBySpace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1018 // NullableTypeSymbolsMustNotBePrecededBySpace
#pragma warning restore SA1018 // NullableTypeSymbolsMustNotBePrecededBySpace
```
