﻿## SA1100

<table>
<tr>
  <td>TypeName</td>
  <td>SA1100DoNotPrefixCallsWithBaseUnlessLocalImplementationExists</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1100</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A call to a member from an inherited class begins with `base.`, and the local class does not contain an override or implementation of the member.

## Rule description

A violation of this rule occurs whenever the code contains a call to a member from the base class prefixed with `base.`, and there is no local implementation of the member. For example:

```csharp
string name = base.JoinName("John", "Doe");
```

This rule is in place to prevent a potential source of bugs. Consider a base class which contains the following virtual method:

```csharp
public virtual string JoinName(string first, string last)
{
}
```

Another class inherits from this base class but does not provide a local override of this method. Somewhere within this class, the base class method is called using `base.JoinName(...)`. This works as expected. At a later date, someone adds a local override of this method to the class:

```csharp
public override string JoinName(string first, string last)
{
    return "Bob";
}
```

At this point, the local call to `base.JoinName(...)` most likely introduces a bug into the code. This call will always call the base class method and will cause the local override to be ignored. 

For this reason, calls to members from a base class should not begin with `base.`, unless a local override is implemented, and the developer wants to specifically call the base class member. When there is no local override of the base class member, the call should be prefixed with `this.` rather than `base.`.

## How to fix violations

To fix a violation of this rule, change the `base.` prefix to `this.`.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1100:DoNotPrefixCallsWithBaseUnlessLocalImplementationExists", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1100 // DoNotPrefixCallsWithBaseUnlessLocalImplementationExists
#pragma warning restore SA1100 // DoNotPrefixCallsWithBaseUnlessLocalImplementationExists
```
