﻿## SA1112

<table>
<tr>
  <td>TypeName</td>
  <td>SA1112ClosingParenthesisMustBeOnLineOfOpeningParenthesis</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1112</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The closing parenthesis or bracket in a call to a C# method or indexer, or the declaration of a method or indexer, is not placed on the same line as the opening bracket when the element does not take any parameters.

## Rule description

A violation of this rule occurs when a method or indexer does not take any parameters and the closing bracket of a call or declaration for the method or indexer is not placed on the same line as the opening bracket. The following example shows correct placement of the closing parenthesis:

```csharp
public string GetName()
{
    return this.name.Trim();
}
```

## How to fix violations

To fix a violation of this rule, ensure that the closing bracket is placed on the same line as the opening bracket.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1112:ClosingParenthesisMustBeOnLineOfOpeningParenthesis", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1112 // ClosingParenthesisMustBeOnLineOfOpeningParenthesis
#pragma warning restore SA1112 // ClosingParenthesisMustBeOnLineOfOpeningParenthesis
```
