﻿## SA1205

<table>
<tr>
  <td>TypeName</td>
  <td>SA1205PartialElementsMustDeclareAccess</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1205</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

The partial element does not have an access modifier defined.

## Rule description

A violation of this rule occurs when the partial elements does not have an access modifier defined.

## How to fix violations

To fix an instance of this violation, specify an access modifier for the partial element.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1205:PartialElementsMustDeclareAccess", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1205 // PartialElementsMustDeclareAccess
#pragma warning restore SA1205 // PartialElementsMustDeclareAccess
```
