﻿## SA1311

<table>
<tr>
  <td>TypeName</td>
  <td>SA1311StaticReadonlyFieldsMustBeginWithUpperCaseLetter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1311</td>
</tr>
<tr>
  <td>Category</td>
  <td>Naming Rules</td>
</tr>
</table>

## Cause

The name of a static readonly field does not begin with an upper-case letter.

## Rule description

A violation of this rule occurs when the name of a static readonly field begins with a lower-case letter. 

## How to fix violations

To fix a violation of this rule, change the name of the field so that it begins with an upper-case letter.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.NamingRules", "SA1311:StaticReadonlyFieldsMustBeginWithUpperCaseLetter", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1311 // StaticReadonlyFieldsMustBeginWithUpperCaseLetter
#pragma warning restore SA1311 // StaticReadonlyFieldsMustBeginWithUpperCaseLetter
```
