﻿## SA1401

<table>
<tr>
  <td>TypeName</td>
  <td>SA1401FieldsMustBePrivate</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1401</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A field within a C# class has an access modifier other than private.

## Rule description

A violation of this rule occurs whenever a field in a class is given non-private access. For maintainability reasons, properties should always be used as the mechanism for exposing fields outside of a class, and fields should always be declared with private access. This allows the internal implementation of the property to change over time without changing the interface of the class.

Fields located within C# structs are allowed to have any access level.

Fields that are static and readonly will not raise a violation. These kinds of fields are commonly used to represent a constant value when the `const` keyword cannot be used, and therefore they are exempt from this rule.

## How to fix violations

To fix a violation of this rule, make the field private and add a property to expose the field outside of the class.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1401:FieldsMustBePrivate", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1401 // FieldsMustBePrivate
#pragma warning restore SA1401 // FieldsMustBePrivate
```
