﻿## SA1405

<table>
<tr>
  <td>TypeName</td>
  <td>SA1405DebugAssertMustProvideMessageText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1405</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A call to Debug.Assert in C# code does not include a descriptive message.

## Rule description

A violation of this rule occurs when the code contains a call to Debug.Assert which does not provide a description for the end-user. For example, the following assert includes a description message:

```csharp
Debug.Assert(value != true, "The value must always be true.");
```

## How to fix violations

To fix a violation of this rule, add a descriptive message to the assert which will appear to the end user when the assert is fired.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1405:DebugAssertMustProvideMessageText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1405 // DebugAssertMustProvideMessageText
#pragma warning restore SA1405 // DebugAssertMustProvideMessageText
```
