﻿## SA1407

<table>
<tr>
  <td>TypeName</td>
  <td>SA1407ArithmeticExpressionsMustDeclarePrecedence</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1407</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

A C# statement contains a complex arithmetic expression which omits parenthesis around operators.

## Rule description

C# maintains a hierarchy of precedence for arithmetic operators. It is possible in C# to string multiple arithmetic operations together in one statement without wrapping any of the operations in parenthesis, in which case the compiler will automatically set the order and precedence of the operations based on these pre-established rules. For example:

```csharp
int x = 5 + y * b / 6 % z - 2;
```

Although this code is legal, it is not highly readable or maintainable. In order to achieve full understanding of this code, the developer must know and understand the basic operator precedence rules in C#.

This rule is intended to increase the readability and maintainability of this type of code, and to reduce the risk of introducing bugs later, by forcing the developer to insert parenthesis to explicitly declare the operator precedence. The example below shows multiple arithmetic operations surrounded by parenthesis:

```csharp
int x = 5 + (y * ((b / 6) % z)) - 2;
```

Inserting parenthesis makes the code more obvious and easy to understand, and removes the need for the reader to make assumptions about the code.

## How to fix violations

To fix a violation of this rule, insert parenthesis within the arithmetic expression to declare the precedence of the operations.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1407:ArithmeticExpressionsMustDeclarePrecedence", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1407 // ArithmeticExpressionsMustDeclarePrecedence
#pragma warning restore SA1407 // ArithmeticExpressionsMustDeclarePrecedence
```
