﻿## SA1613

<table>
<tr>
  <td>TypeName</td>
  <td>SA1613ElementParameterDocumentationMustDeclareParameterName</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1613</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

A `<param>` tag within a C# element's documentation header is missing a name attribute containing the name of the parameter.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs if the documentation for an element contains a `<param>` tag which is missing a name attribute, or which contains an empty name attribute.

## How to fix violations

To fix a violation of this rule, add or fill-in the name attribute for the `<param>` tag to indicate the name of the parameter that the documentation is for.

The following example shows a method with a valid documentation header:

```csharp
/// <summary>
/// Joins a first name and a last name together into a single string.
/// </summary>
/// <param name="firstName">The first name to join.</param>
/// <param name="lastName">The last name to join.</param>
/// <returns>The joined names.</returns>
public string JoinNames(string firstName, string lastName)
{
    return firstName + " " + lastName;
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1613:ElementParameterDocumentationMustDeclareParameterName", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1613 // ElementParameterDocumentationMustDeclareParameterName
#pragma warning restore SA1613 // ElementParameterDocumentationMustDeclareParameterName
```
