﻿## SA1647

<table>
<tr>
  <td>TypeName</td>
  <td>SA1647IncludeNodeDoesNotContainValidFileAndPath</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1647</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

An include tag within an Xml documentation header does not contain valid file and path attribute.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments.](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments)

As an alternative to authoring documentation directly within the code file, it is possible to place documentation for multiple elements within a separate Xml file, and then reference a section of that file within an element's documentation header. This causes the compiler to import the documentation for that element from the included document. For example:

```csharp
/// <include file="IncludedDocumentation.xml" path="root/EnabledMethodDocs" />
public bool Enabled(bool true)
{
}
```

A violation of this rule occurs when the include tag is missing a file or path attribute, or contains an improperly formatted file or path attribute.

## How to fix violations

To fix a violation of this rule, add or correct the file and path attributes.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1647:IncludeNodeDoesNotContainValidFileAndPath", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1647 // IncludeNodeDoesNotContainValidFileAndPath
#pragma warning restore SA1647 // IncludeNodeDoesNotContainValidFileAndPath
```
