﻿# SA1651

<table>
<tr>
  <td>TypeName</td>
  <td>SA1651DoNotUsePlaceholderElements</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1651</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.

## Cause

The documentation for the element contains one or more `<placeholder>` elements.

## Rule description

A violation of this rule occurs when the element documentation contains `<placeholder>` elements:

```csharp
/// <summary>
/// This method <placeholder>performs some operation</placeholder>.
/// </summary>
public void SomeOperation()
{
}
```

Placeholder elements should be reviewed and removed from documentation.

## How to fix violations

To fix a violation of this rule, review the placeholder documentation for accuracy and remove the `<placeholder>` tags.

## How to suppress violations

```csharp
#pragma warning disable SA1651 // Do not use placeholder elements
/// <summary>
/// This method <placeholder>performs some operation</placeholder>.
/// </summary>
public void SomeOperation()
#pragma warning restore SA1651 // Do not use placeholder elements
{
}
```
