<h2>Why is this an issue?</h2>
<p>If a label is declared but not used in the program, it can be considered as dead code and should therefore be removed.</p>
<p>This will improve maintainability as developers will not wonder what this label is used for.</p>
<h3>Noncompliant code example</h3>

```java
void foo() {
  outer: //label is not used.
  for(int i = 0; i<10; i++) {
    break;
  }
}
```
<h3>Compliant solution</h3>

```java
void foo() {
  for(int i = 0; i<10; i++) {
    break;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/5dUxBQ">CERT, MSC12-C.</a> - Detect and remove code that has no effect or is never executed
  </li>
</ul>