<h2>Why is this an issue?</h2>
<p>Before Java 8, the only way to partially support closures in Java was by using anonymous inner classes. Java 8 introduced lambdas, which are
significantly more readable and should be used instead.</p>
<p>This rule is automatically disabled when the project’s <code>sonar.java.source</code> is lower than <code>8</code>, as lambda expressions were
introduced in Java 8.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
myCollection.stream().map(new Function<String,String>() { // Noncompliant, use a lambda expression instead
  @Override
  public String apply(String input) {
    return new StringBuilder(input).reverse().toString();
  }
})
  ...
```
<h4>Compliant solution</h4>

```java
myCollection.stream()
  .map(input -> new StringBuilder(input).reverse().toString()) // Compliant
    ...
```
<h4>Noncompliant code example</h4>

```java
Predicate<String> isEmpty = new Predicate<String>() { // Noncompliant, use a lambda expression instead
  @Override
  public boolean test(String myString) {
    return myString.isEmpty();
  }
};
```
<h4>Compliant solution</h4>

```java
Predicate<String> isEmpty = myString -> myString.isEmpty(); // Compliant
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/javaOO/lambdaexpressions.html">Lambda Expressions - The Java™ Tutorials</a> </li>
</ul>