<h2>Why is this an issue?</h2>
<p>The <code>java.util.concurrent.locks.Condition</code> interface provides an alternative to the <code>Object</code> monitor methods
(<code>wait</code>, <code>notify</code> and <code>notifyAll</code>). Hence, the purpose of implementing said interface is to gain access to its more
nuanced <code>await</code> methods.</p>
<p>Consequently, calling the method <code>Object.wait</code> on a class implementing the <code>Condition</code> interface is contradictory and should
be avoided. Use <code>Condition.await</code> instead.</p>
<h2>Code examples</h2>
<h3>Noncompliant code example</h3>

```java
void doSomething(Condition condition) {
    condition.wait(); // Noncompliant, Object.wait is called

        ...
}
```
<h3>Compliant solution</h3>

```java
void doSomething(Condition condition) {
    condition.await(); // Compliant, Condition.await is called

        ...
}
```
<h2>References</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/util/concurrent/locks/Condition.html">Interface Condition - Java™ Platform SE 8, API
  Specification</a> </li>
</ul>