<p>This rule raises an issue when there is a method and a field in a class with names that differ only by capitalization.</p>
<h2>Why is this an issue?</h2>
<p>Looking at the set of methods in a class, including superclass methods, and finding two methods or fields that differ only by capitalization is
confusing to users of the class. It is similarly confusing to have a method and a field which differ only in capitalization or a method and a field
with exactly the same name and visibility.</p>
<p>In the case of methods, it may have been a mistake on the part of the original developer, who intended to override a superclass method, but instead
added a new method with nearly the same name.</p>
<p>Otherwise, this situation simply indicates poor naming. Method names should be action-oriented, and thus contain a verb, which is unlikely in the
case where both a method and a member have the same name (with or without capitalization differences). However, renaming a public method could be
disruptive to callers. Therefore renaming the member is the recommended action.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
public class Car{

  public DriveTrain drive;

  public void tearDown(){...}

  public void drive() {...}  // Noncompliant; duplicates field name
}

public class MyCar extends Car{
  public void teardown(){...}  // Noncompliant; not an override. It it really what's intended?

  public void drivefast(){...}

  public void driveFast(){...} //Huh?
}
```
<h4>Compliant solution</h4>

```java
public class Car{

  private DriveTrain drive;

  public void tearDown(){...}

  public void drive() {...}  // field visibility reduced
}

public class MyCar extends Car{
  @Override
  public void tearDown(){...}

  public void drivefast(){...}

  public void driveReallyFast(){...}

}
```