<h2>Why is this an issue?</h2>
<p>There’s no point in having a JUnit <code>TestCase</code> without any test methods. Similarly, you shouldn’t have a file in the tests directory
named <code>*Test</code>, <code>*Tests</code>, or <code>*TestCase</code>, but no tests in the file. Doing either of these things may lead someone to
think that uncovered classes have been tested.</p>
<p>This rule raises an issue when files in the test directory are named <code>*Test</code>, <code>*Tests</code>, or <code>*TestCase</code> or
implement <code>TestCase</code> but don’t contain any tests.</p>
<p>Supported frameworks:</p>
<ul>
  <li> JUnit3 </li>
  <li> JUnit4 </li>
  <li> JUnit5 </li>
  <li> TestNG </li>
  <li> Zohhak </li>
  <li> ArchUnit </li>
  <li> Pact </li>
</ul>