<h2>Why is this an issue?</h2>
<p>In a multi-threaded situation, un-<code>synchronized</code> lazy initialization of static fields could mean that a second thread has access to a
half-initialized object while the first thread is still creating it. Allowing such access could cause serious bugs. Instead. the initialization block
should be <code>synchronized</code>.</p>
<p>Similarly, updates of such fields should also be <code>synchronized</code>.</p>
<p>This rule raises an issue whenever a lazy static initialization is done on a class with at least one <code>synchronized</code> method, indicating
intended usage in multi-threaded applications.</p>
<h3>Noncompliant code example</h3>

```java
private static Properties fPreferences = null;

private static Properties getPreferences() {
        if (fPreferences == null) {
            fPreferences = new Properties(); // Noncompliant
            fPreferences.put("loading", "true");
            fPreferences.put("filterstack", "true");
            readPreferences();
        }
        return fPreferences;
    }
}
```
<h3>Compliant solution</h3>

```java
private static Properties fPreferences = null;

private static synchronized Properties getPreferences() {
        if (fPreferences == null) {
            fPreferences = new Properties();
            fPreferences.put("loading", "true");
            fPreferences.put("filterstack", "true");
            readPreferences();
        }
        return fPreferences;
    }
}
```