<h2>Why is this an issue?</h2>
<p>Synchronizing on a class field synchronizes not on the field itself, but on the object assigned to it. So synchronizing on a non-<code>final</code>
field makes it possible for the field’s value to change while a thread is in a block synchronized on the old value. That would allow a second thread,
synchronized on the new value, to enter the block at the same time.</p>
<p>The story is very similar for synchronizing on parameters; two different threads running the method in parallel could pass two different object
instances in to the method as parameters, completely undermining the synchronization.</p>
<h3>Noncompliant code example</h3>

```java
private String color = "red";

private void doSomething(){
  synchronized(color) {  // Noncompliant; lock is actually on object instance "red" referred to by the color variable
    //...
    color = "green"; // other threads now allowed into this block
    // ...
  }
  synchronized(new Object()) { // Noncompliant this is a no-op.
     // ...
  }
}
```
<h3>Compliant solution</h3>

```java
private String color = "red";
private final Object lockObj = new Object();

private void doSomething(){
  synchronized(lockObj) {
    //...
    color = "green";
    // ...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/412">CWE-412 - Unrestricted Externally Accessible Lock</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/413">CWE-413 - Improper Resource Locking</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/djdGBQ">CERT, LCK00-J.</a> - Use private final lock objects to synchronize classes that may
  interact with untrusted code </li>
</ul>