<h2>Why is this an issue?</h2>
<p>An <code>ObjectOutputStream</code> writes primitive data types and graphs of Java objects to an <code>OutputStream</code>. The objects can be read
(reconstituted) using an <code>ObjectInputStream</code>.</p>
<p>When <code>ObjectOutputStream</code> is used with files opened in append mode, it can cause data corruption and unexpected behavior. This is
because when <code>ObjectOutputStream</code> is created, it writes metadata to the output stream, which can conflict with the existing metadata when
the file is opened in append mode. This can lead to errors and data loss.</p>
<p>When used with serialization, an <code>ObjectOutputStream</code> first writes the serialization stream header. This header should appear once per
file at the beginning. When you’re trying to read your object(s) back from the file, only the first one will be read successfully, and a
<code>StreamCorruptedException</code> will be thrown after that.</p>
<h2>How to fix it</h2>
<p>Open the file to use the default action (writes stream header).</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
FileOutputStream fos = new FileOutputStream(fileName , true);  // fos opened in append mode
ObjectOutputStream out = new ObjectOutputStream(fos);  // Noncompliant
```
<h4>Compliant solution</h4>

```java
FileOutputStream fos = new FileOutputStream(fileName);
ObjectOutputStream out = new ObjectOutputStream(fos);
```
<h2>Resources</h2>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://docs.jboss.org/jbossas/javadoc/4.0.2/org/jboss/util/stream/AppendingObjectOutputStream.java.html">JBoss -
  AppendingObjectOutputStream</a> </li>
</ul>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/en/java/javase/20/docs/api/java.base/java/io/ObjectOutputStream.html">Oracle SE 20 - ObjectOutputStream</a>
  </li>
</ul>