<h2>Why is this an issue?</h2>
<p>Most checks against an <code>indexOf</code> value compare it with -1 because 0 is a valid index. Checking against <code>&gt; 0</code> ignores the
first element, which is likely a bug.</p>

```java
String name = "ishmael";

if (name.indexOf("ish") > 0) { // Noncompliant
  // ...
}
```
<p>Moreover, if the intent is merely to check the inclusion of a value in a <code>String</code> or a <code>List</code>, consider using the
<code>contains</code> method instead.</p>

```java
String name = "ishmael";

if (name.contains("ish") {
  // ...
}
```
<p>If the intent is really to skip the first element, comparing it with <code>&gt;=1</code> will make it more straightforward.</p>

```java
String name = "ishmael";

if (name.indexOf("ish") >= 1) {
  // ...
}
```
<p>This rule raises an issue when an <code>indexOf</code> value retrieved from a <code>String</code> or a <code>List</code> is tested against
<code>&gt; 0</code>.</p>