<h2>Why is this an issue?</h2>
<p>When a method loops multiple over the same set of data, whether it’s a list or a set of numbers, it is highly likely that the method could be made
more efficient by combining the loops into a single set of iterations.</p>
<h3>Noncompliant code example</h3>

```java
public void doSomethingToAList(List<String> strings) {
  for (String str : strings) {
    doStep1(str);
  }
  for (String str : strings) {  // Noncompliant
    doStep2(str);
  }
}
```
<h3>Compliant solution</h3>

```java
public void doSomethingToAList(List<String> strings) {
  for (String str : strings) {
    doStep1(str);
    doStep2(str);
  }
}
```