<h2>Why is this an issue?</h2>
<p>Providing a <code>serialVersionUID</code> field on <code>Serializable</code> classes is strongly recommended by the <code>Serializable</code>
documentation but blindly following that recommendation can be harmful.</p>
<p><code>serialVersionUID</code> value is stored with the serialized data and this field is verified when deserializing the data to ensure that the
code reading the data is compatible with the serialized data. In case of failure, it means the serialized data and the code are not in sync and this
fine because you know what’s wrong.</p>
<p>When the <code>serialVersionUID</code> is generated by an IDE or blindly hard-coded, there is a high probability that one will forget to update the
<code>serialVersionUID</code> value when the <code>Serializable</code> class is later enriched with additional fields. As a consequence, old
serialized data will incorrectly be considered compatible with the newer version of the code creating situations which are hard to debug.</p>
<p>Therefore, defining <code>serialVersionUID</code> should be done with care. This rule raises an issue on each <code>serialVersionUID</code> field
declared on classes implementing <code>Serializable</code> to be sure the presence and the value of the <code>serialVersionUID</code> field is
challenged and validated by the team.</p>
<h3>Noncompliant code example</h3>

```java
public class Foo implements Serializable {
  private static final long serialVersionUID = 1;
}

public class BarException extends RuntimeException {
  private static final long serialVersionUID = 8582433437601788991L;
}
```
<h2>Resources</h2>
<ul>
  <li> Vojtech Ruzicka’s Programming Blog: <a href="https://www.vojtechruzicka.com/explicitly-declare-serialversionuid/">Should I explicitly declare
  serialVersionUID?</a> </li>
</ul>