<h2>Why is this an issue?</h2>
<p>Since Java 9, <code>@Deprecated</code> has two additional arguments to the annotation:</p>
<ul>
  <li> <code>since</code> allows you to describe when the deprecation took place </li>
  <li> <code>forRemoval</code>, indicates whether the deprecated element will be removed at some future date </li>
</ul>
<p>In order to ease the maintainers work, it is recommended to always add one or both of these arguments.</p>
<p>This rule reports an issue when <code>@Deprecated</code> is used without any argument.</p>
<h3>Noncompliant code example</h3>

```java
@Deprecated
```
<h3>Compliant solution</h3>

```java
@Deprecated(since="4.2", forRemoval=true)
```
<h3>Exceptions</h3>
<p>The members and methods of a deprecated class or interface are ignored by this rule. The classes and interfaces themselves are still subject to
it.</p>
<h2>Resources</h2>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S1123'>java:S1123</a> </li>
</ul>