<h2>Why is this an issue?</h2>
<p>The <code>Thread</code> class has some methods that are used to monitor and manage its execution. With the introduction of virtual threads in Java
21, there are three of these methods that behave differently between the standard platform threads and the virtual ones.</p>
<p>For virtual threads:</p>
<ul>
  <li> <code>Thread.setDaemon(boolean)</code> will throw an <code>IllegalArgumentException</code> if <code>false</code> is passed as an argument as a
  virtual thread daemon status is always true. </li>
  <li> <code>Thread.setPriority(int priority)</code> will never change the actual priority of a virtual thread, which is always equal to
  <code>Thread.NORM_PRIORITY</code> </li>
  <li> <code>Thread.getThreadGroup()</code> will return a dummy "VirtualThreads" group that is empty and should not be used </li>
</ul>
<p>This rule reports an issue when one of these methods is invoked on a virtual thread.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
Thread t = Thread.ofVirtual().unstarted(()->{/* some task */});
t.setPriority(1); // Noncompliant; virtual threads' priority cannot be changed
t.setDaemon(false); // Noncompliant; will throw IllegalArgumentException
t.setDaemon(true); // Noncompliant; redundant
t.start();
var threadGroup = t.getThreadGroup(); // Noncompliant; virtual thread groups should not be used
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Java Documentation - <a
  href="https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/Thread.html#setDaemon(boolean)">Thread.setDaemon</a> </li>
  <li> Java Documentation - <a
  href="https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/Thread.html#setPriority(int)">Thread.setPriority</a> </li>
  <li> Java Documentation - <a
  href="https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/Thread.html#getThreadGroup()">Thread.getThreadGroup</a> </li>
  <li> Java Documentation - <a
  href="https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/lang/ThreadGroup.html#virtualthreadgroup">Virtual threads group</a> </li>
</ul>