<h2>Why is this an issue?</h2>
<p>Testing <code>for</code> loop termination using an equality operator (<code>==</code> and <code>!=</code>) is dangerous, because it could set up an
infinite loop. Using a broader relational operator instead casts a wider net, and makes it harder (but not impossible) to accidentally write an
infinite loop.</p>
<h3>Noncompliant code example</h3>

```java
for (int i = 1; i != 10; i += 2)  // Noncompliant. Infinite; i goes from 9 straight to 11.
{
  //...
}
```
<h3>Compliant solution</h3>

```java
for (int i = 1; i <= 10; i += 2)  // Compliant
{
  //...
}
```
<h3>Exceptions</h3>
<p>Equality operators are ignored if the loop counter is not modified within the body of the loop and either:</p>
<ul>
  <li> starts below the ending value and is incremented by 1 on each iteration. </li>
  <li> starts above the ending value and is decremented by 1 on each iteration. </li>
</ul>
<p>Equality operators are also ignored when the test is against <code>null</code>.</p>

```java
for (int i = 0; arr[i] != null; i++) {
  // ...
}

for (int i = 0; (item = arr[i]) != null; i++) {
  // ...
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/835">CWE-835 - Loop with Unreachable Exit Condition ('Infinite Loop')</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/x9YxBQ">CERT, MSC21-C.</a> - Use robust loop termination conditions </li>
</ul>