<h2>Why is this an issue?</h2>
<p>Functions with a long parameter list are difficult to use because maintainers must figure out the role of each parameter and keep track of their
position.</p>

```js
function setCoordinates(x1, y1, z1, x2, y2, z2) { // Noncompliant
    // ...
}
```
<p>The solution can be to:</p>
<ul>
  <li> Split the function into smaller ones </li>
</ul>

```js
// Each function does a part of what the original setCoordinates function was doing, so confusion risks are lower
function setOrigin(x, y, z) {
   // ...
}

function setSize(width, height, depth) {
   // ...
}
```
<ul>
  <li> Find a better data structure for the parameters that group data in a way that makes sense for the specific application domain </li>
</ul>

```js
// In geometry, Point is a logical structure to group data
let point1 = { x: x1, y: y1, z: z1};
let point2 = { x: x1, y: y1, z: z1};
setCoordinates(point1, point2);

function setCoordinates(p1, p2) {
   // ...
}
```
<p>This rule raises an issue when a function has more parameters than the provided threshold.</p>
<h3>Exceptions</h3>
<p>The rule ignores TypeScript parameter properties when counting parameters:</p>

```js
class C {
  constructor(
    private param1: number,     // ignored
    param2: boolean,            // counted
    public param3: string,      // ignored
    readonly param4: string[],  // ignored
    param5: number | string     // counted
  ) {} // Compliant by exception
}
```
<p>The rule also ignores Angular component constructors:</p>

```js
import { Component } from '@angular/core';

@Component({/* ... */})
class Component {
  constructor(p1, p2, p3, p4, p5) {} // Compliant by exception
}
```